#!/usr/bin/perl
#
#	Author:		Sliced Apple
#	Created:	7/2/2005
#	Modified: 	12/2025
#
#	CGI to create a page counter and a site counter that generates
#	four sets of values for each page
#	1) Number of unique visits to each page from a unique IP address
#	2) Number of total visits to each page from any IP address
#	3) Number of unique visits to the site from a unique IP address
#	4) Number of total visits to the site from any IP address
#
#	It designed to created a unique log for each page used to call this
#	script
#
#	This script will automatically creat all log and data files it needs
#	You only need to place a call to the script in each webpage on a site, and
#	also create a directory named "logs" in the same directory that contains
#	this Perl script
#
#	For example, you need to place:
#	<p><!--#include virtual="/cgi-bin/universal_page_counter.pl" --></p>
#	in the HTML of each web page, and, in this example, create a directory
#	/cgi-bin/logs
#
#	You can change $my_domain_name to your your domain if you want to block
#	visit from devices that share a public IP address with the host
#

#       Send errors to browser - should be commented out when not debugging
use CGI::Carp qw (fatalsToBrowser);

use CGI qw(:standard);
my $q = CGI->new;
# 	Reads variable passed from called webpage - not needed as we now
#	directly read the webpage source file name
# my $calling_page = $q->param('pagename');

#       This sets up the HTML output (required)
print "Content-type: text/html\r\n\r\n";

#	Sets the your domain name to allow no logging of internal visits
$my_domain_name = "slicedapple.org";

#	If no_change is 1 then no updating of logs
#	This is used to prevent log update for certain situations, such as
#	running from localhost or from internal to the Website and this value might
#	be modified later in this script
$no_change = 0;

#	If no_log is 1 then this also prevents updating of logs
#	Change this to 1 if you want this script to continue loading and 
#	displaying the counters, but not update the log, this is set here and 
#	is NOT modified later - use this is you just want to suspend logging but not
#	disable or remove the script
$no_log = 0;

#	Get the name of the calling HTML file including parsing the URL
my $referrer_url = $q->url(); 
$last_slash_pos = rindex($referrer_url, '/');
$calling_page = substr($referrer_url, $last_slash_pos + 1);

#	If calling_page an empty string (so loading the index page) then set to index.html
if ($calling_page eq '') {
$calling_page = 'index.html';
}

#	Sets the IP address of the visiting browser
$remote_address = $ENV{REMOTE_ADDR};

#	Get IP address of hosting website (slicedapple for this  code - change as
#	neccessary)
my $host_ip_address = '';
my $host_ip_address = qx(dig +short $my_domain_name);

#	This section sets no_change to 1 if referrer contains localhost or the same IP as host
#	or using a private IP address defined for this script as an IP starting with 192.168
if ((index($referrer_url, 'localhost') != -1) or (index($host_ip_address, $remote_address) != -1) or (index($remote_address, '192.168') != -1))  {
$no_change =1;
}

#	This section sets up the various log and data files, with files given page
#	specific names, such as index.html.log.
#
# 	stores the IP addresses used to visit the site
$site_ips_log = "logs/site_ips.log";

#       stores the IP addresses used to visit the page
$page_ips_log = "logs/" . $calling_page . "_ips.log";

# 	unique_site_count.log stores the unique visits to the site
$unique_site_count_log = "logs/unique_site_count.log";

# 	total_site_count.log stores the total visits to the site
$total_site_count_log = "logs/total_site_count.log";

#       page_unique_site_count.log stores the unique vist count for THIS page,
#	provided the pagename variable was changed before being passed from the calling HTML file
$unique_page_count_log = "logs/unique_" . $calling_page . "_count.log";

#       total_page_unique_site_count.log stores the unique vist count for THIS page,
#	provided the pagename variable was changed before being passed from the calling HTML file
$total_page_count_log = "logs/total_" . $calling_page . "_count.log";

#	This section sets up the various file handles
#
$SITEIPSLOG = "filehandle";
$PAGEIPSLOG = "filehandle";
$PAGECOUNTLOG = "filehandle";
$TOTALPAGECOUNTLOG = "filehandle";
$SITECOUNTLOG = "filehandle";
$TOTALSITECOUNTLOG = "filehandle";

#	This section retrieves a list of all prior IP addresses for the specific page and the 
#	complete web site
#
# Get list of all IP addresses for the site
open(SITEIPSLOG,"$site_ips_log");
@site_ips = <SITEIPSLOG>;
close(SITEIPSLOG);

# Get list of all IP addresses for THIS page
open(PAGEIPSLOG,"$page_ips_log");
@page_ips = <PAGEIPSLOG>;
close(PAGEIPSLOG);

#	Sets the boolean variables for an IP match for the site and page to no 0 (which
#	means a new unique visit). This will be changed to 1 if there is an IP match
#
$ipmatch_site = 0;
$ipmatch_page = 0;

#	This sections scans the IP addresses for the page and site to see if there is a match
#
#	Parse the IP addresses for THIS page and set value if matching IP found
foreach $ip(@page_ips) { chomp($ip);

	if ($ip eq "$remote_address") {
	$ipmatch_page = 1;
}
}

#	Parse the IP addresses for this site and set value if matching IP found
foreach $ip(@site_ips) { chomp($ip);

	if ($ip eq "$remote_address") {
	$ipmatch_site = 1;
}
}

#
#	This sections reads all the logs for the four counts: unique page, total page, unique site,
#	and total site
#
#	Get the unique counts for THIS page
open(PAGECOUNTLOG,"$unique_page_count_log");
$page_count  = <PAGECOUNTLOG>;
close(PAGECOUNTLOG);

#	Get the total counts for THIS page
open(TOTALPAGECOUNTLOG,"$total_page_count_log");
$total_page_count  = <TOTALPAGECOUNTLOG>;
close(TOTALPAGECOUNTLOG);

#	Get the unique counts for the site
open(SITECOUNTLOG,"$unique_site_count_log");
$unique_count  = <SITECOUNTLOG>;
close(SITECOUNTLOG);

#	Get the total counts for the site
open(TOTALSITECOUNTLOG,"$total_site_count_log");
$total_visit_count  = <TOTALSITECOUNTLOG>;
close(TOTALSITECOUNTLOG);
	
#	This section increases the various counts by 1
#
#	Increase the unique page count by 1
$new_unique_page_count = ($page_count) + (1);

#	Increase the unique site count by 1
$new_unique_site_count = ($unique_count) + (1);

#       Increase the total page count by 1
$new_total_page_count = ($total_page_count) + (1);

#       Increase the total site count by 1
$new_total_count = ($total_visit_count) + (1);

#	This section updates all this logs (if allowed)
#	Only updates if both no_log and no_change are 0 (false)
#
if (($no_log eq 0) and ($no_change eq 0)) {

#		If changes to the two unique logs are allowed the logs are updated
	if ($ipmatch_site  eq  0) {
#       Save the updated total site count back to the log
	open(SITECOUNTLOG,">$unique_site_count_log");
	print SITECOUNTLOG "$new_unique_site_count";
	close(SITECOUNTLOG);

#	Save the new IP address to the site IP log
	open(SITEIPSLOG,">>$site_ips_log");
	print SITEIPSLOG "$ENV{REMOTE_ADDR}\n";
	close(SITEIPSLOG);
	}

	if ($ipmatch_page  eq  0) {
#		Save the the update total page count back to the log
	open(PAGECOUNTLOG,">$unique_page_count_log");
	print PAGECOUNTLOG "$new_unique_page_count";
	close(PAGECOUNTLOG);
#       	Save the new IP address to the site IP log
	open(PAGEIPSLOG,">>$page_ips_log");                 
	print PAGEIPSLOG "$ENV{REMOTE_ADDR}\n";
	close(PAGEIPSLOG);
	}

#		The two total visit logs are updated.
#
#       	Save the the update total site count back to the log
	open(SITECOUNTLOG,">$total_site_count_log");
	print SITECOUNTLOG "$new_total_count";
	close(SITECOUNTLOG);

#		Save the the update total page count back to the log
	open(TOTALPAGECOUNTLOG,">$total_page_count_log");
	print TOTALPAGECOUNTLOG "$new_total_page_count";
	close(TOTALPAGECOUNTLOG);
}

#	HTML Output - outputs the four logs to the calling webpage

print "<br />";print "<span style=\"font-weight: bold;\">Visit Counters</span><br /><br />";

#	Prints all the visit counts
print 'Unique visits to this page (' . $calling_page . ') from a unique IP Address: ';
print "<span style=\"font-weight: bold;\">" . $page_count . "</span>";
print "<br />";
print 'Total visits to this page (' . $calling_page . ') from any IP Address: ';
print "<span style=\"font-weight: bold;\">" . $total_page_count . "</span>";
print "<br />";
print "Unique visits to Sliced Apple from a unique IP Addresses: ";
print "<span style=\"font-weight: bold;\">" . $unique_count . "</span>";
print "<br />";
print "Total visits to Sliced Apple from any IP Address: ";
print "<span style=\"font-weight: bold;\">" . $total_visit_count . "</span>";

#
#	Reports any flags that prevent logging
if ($no_change == 1) {
print "<br >";
print "<br >";
print "<span style=\"font-weight: bold;\">THIS VIST NOT LOGGED DUE TO INTERNAL SITE VISIT. </span>(no_change : ". $no_change . ")";
print "<br >";
print "referrer URL: " . $referrer_url . ", client IP: ". $remote_address;
}
if ($no_log == 1) {
print "<br >";
print "<br >";
print "<span style=\"font-weight: bold;\">LOGGING DISABLED IN SCRIPT CODE. </span>(no_log : ". $no_log . ")";
print "<br >";
print 'To enable logging change $no_log = 1 to $no_log = 0.';
}
#	THE END
#
